package com.example.mysampleapp.ui.main

import android.util.Log
import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.ViewModel
import com.jakewharton.rxbinding2.InitialValueObservable
import io.reactivex.Observable
import java.util.regex.Pattern
import io.reactivex.functions.Function

class Book {
    var title: String? = null
    var author: String? = null
    var publisher: String? = null
    var isbn: String? = null

    constructor(t: String?, a: String?, p: String?, i: String?) {
        title = t
        author = a
        publisher = p
        isbn = i
    }

    fun getDetails(): String {
        return "\nTitle: $title\nAuthor: $author" +
                "\nPublisher: $publisher\nISBN: $isbn\n"
    }
}

class LibraryAdminViewModel : ViewModel() {
    private var data: MutableLiveData<String?>? = MutableLiveData()

    fun setBook(t: String?, a: String?, p: String?, i: String?) {
        var b = Book(t, a, p, i)
        Log.d("TAG", "setBook: " + b.getDetails())
        data?.setValue(b.getDetails())
    }

    fun getBook(): MutableLiveData<String?>? {
        return data
    }

    fun validateIsbn(text: InitialValueObservable<CharSequence>): Observable<Boolean> {
        val isbnPattern = Pattern.compile("^\\d{3}\\-\\d{1}\\-\\d{2}\\-\\d{6}\\-\\d{1}$")
        return text?.map<Boolean>(Function { text: CharSequence? ->
            isbnPattern.matcher(
                text
            ).find()
        })
    }

    fun getSubmitButtonEnabled(
        isValidIsbn: Observable<Boolean>
    ): Observable<Boolean>? {
        return isValidIsbn
    }
}