package com.example.mysampleapp.ui.main

import android.os.Bundle
import android.util.Log
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.fragment.app.Fragment
import androidx.lifecycle.Observer
import androidx.lifecycle.ViewModelProvider
import com.example.mysampleapp.R
import com.jakewharton.rxbinding2.widget.RxTextView
import io.reactivex.Observable
import io.reactivex.android.schedulers.AndroidSchedulers
import io.reactivex.functions.Function
import kotlinx.android.synthetic.main.library_admin_fragment.*
import java.util.regex.Pattern

class LibraryAdminFragment : Fragment() {

    companion object {
        fun newInstance() = LibraryAdminFragment()
    }

    private lateinit var viewModel: LibraryAdminViewModel

    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View {
        return inflater.inflate(R.layout.library_admin_fragment, container, false)
    }

    override fun onActivityCreated(savedInstanceState: Bundle?) {
        super.onActivityCreated(savedInstanceState)
        viewModel = ViewModelProvider(this).get(LibraryAdminViewModel::class.java)

        val resultObserver: Observer<String?> = object : Observer<String?> {
            override fun onChanged(t: String?) {
                result.setText(t.toString())
                Log.d("TAG", "resultObserver: " + t)
            }
        }

        viewModel.getBook()?.observe(this, resultObserver)

        btnSubmit.setOnClickListener {
            viewModel.setBook(
                titleText.text.toString(),
                authorText.text.toString(),
                publisherText.text.toString(),
                isbnText.text.toString()
            )
        }

        val isbn = RxTextView.textChanges(isbnText)

        val isValidIsbn: Observable<Boolean> = viewModel.validateIsbn(isbn)

        viewModel.getSubmitButtonEnabled(isValidIsbn)?.observeOn(AndroidSchedulers.mainThread())
            ?.subscribe(btnSubmit::setEnabled)
    }


}