package com.example.mysampleapp.ui.main

import android.os.Bundle
import android.util.Log
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.fragment.app.Fragment
import androidx.lifecycle.Observer
import androidx.lifecycle.ViewModelProvider
import com.example.mysampleapp.R
import kotlinx.android.synthetic.main.currency_livedata_fragment.*

class CurrencyLiveDataFragment : Fragment() {

    companion object {
        fun newInstance() = CurrencyLiveDataFragment()
    }

    private lateinit var viewModel: CurrencyLiveDataViewModel

    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View {
        Log.d("TAG", "CurrencyLiveDataFragment: onCreateView")
        return inflater.inflate(R.layout.currency_livedata_fragment, container, false)
    }

    override fun onActivityCreated(savedInstanceState: Bundle?) {
        Log.d("TAG", "CurrencyLiveDataFragment: onActivityCreated")
        super.onActivityCreated(savedInstanceState)
        viewModel = ViewModelProvider(this).get(CurrencyLiveDataViewModel::class.java)

        val resultObserver: Observer<Float?> = object : Observer<Float?> {
            override fun onChanged(result: Float?) {
                resultText2.setText(result.toString())
            }
        }

//        resultText2.setText(viewModel.getResult().toString())
        viewModel.getResult()?.observe(this, resultObserver);

        convertButton2.setOnClickListener {
            if (!dollarText2.getText().toString().equals("")) {
                viewModel.setAmount(dollarText2.getText().toString());
//                resultText2.setText(viewModel.getResult().toString());
            } else {
                resultText2.setText("No Value");
            }
        }
    }

}