package com.example.mysampleapp.ui.main

import androidx.lifecycle.ViewModelProvider
import android.os.Bundle
import android.util.Log
import androidx.fragment.app.Fragment
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import com.example.mysampleapp.R
import kotlinx.android.synthetic.main.main_fragment.*

class CurrencyConverterFragment : Fragment() {

    companion object {
        fun newInstance() = CurrencyConverterFragment()
    }

    private lateinit var viewModel: CurrencyViewModel

    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View {
        Log.d("TAG", "CurrencyConverterFragment: onCreateView")
        return inflater.inflate(R.layout.main_fragment, container, false)
    }

    override fun onActivityCreated(savedInstanceState: Bundle?) {
        Log.d("TAG", "CurrencyConverterFragment: onActivityCreated")
        super.onActivityCreated(savedInstanceState)
        viewModel = ViewModelProvider(this).get(CurrencyViewModel::class.java)

        resultText.setText(viewModel.getResult().toString())
        
        convertButton.setOnClickListener {
            if (!dollarText.getText().toString().equals("")) {
                viewModel.setAmount(dollarText.getText().toString());
                resultText.setText(viewModel.getResult().toString());
            } else {
                resultText.setText("No Value");
            }
        }
    }

}