package com.example.mysampleapp

import androidx.appcompat.app.AppCompatActivity
import android.os.Bundle
import com.jakewharton.rxbinding2.widget.RxTextView
import kotlinx.android.synthetic.main.activity_text_search.*

class TextSearchActivity : AppCompatActivity() {
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_text_search)

        RxTextView.textChanges(text_search)
            .filter { text -> text.length >= 3 }
            .subscribe(::updateSearchResults)
    }

    private fun updateSearchResults(text: CharSequence) {
        result_text.setText("")
        if(text.length <= 7){
            result_text.setText("" + text + Math.random())
        } else {
            result_text.setText("Text too long")
        }
    }
}