package com.example.mysampleapp;

import androidx.appcompat.app.AppCompatActivity;

import android.os.Bundle;
import android.util.Log;
import android.widget.ArrayAdapter;
import android.widget.ListView;

import com.example.mysampleapp.network.Entry;
import com.example.mysampleapp.network.FeedObservable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;

public class RssFeedActivity extends AppCompatActivity {

    private static final String TAG = MainActivity.class.getSimpleName();

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_rss_feed);

       Observable<List<Entry>> purpleFeedObservable =
                FeedObservable.getFeed(
                        "https://news.google.com/?output=atom");

        Observable<List<Entry>> yellowFeedObservable =
                FeedObservable.getFeed(
                        "http://www.theregister.co.uk/software/headlines.atom");

        Observable<List<Entry>> combinedObservable =
                Observable.combineLatest(
                        purpleFeedObservable, yellowFeedObservable,
                        (purpleList, yellowList) -> {
                            final List<Entry> list = new ArrayList<>();
                            list.addAll(purpleList);
                            list.addAll(yellowList);
                            return list;
                        }
                );

        combinedObservable
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe(this::drawList);

        // sort
//        Observable<List<Entry>> sortedListObservable =
//                combinedObservable.map(this::sortList);
//
//        sortedListObservable
//                .observeOn(AndroidSchedulers.mainThread())
//                .subscribe(this::drawList);
    }

    private void drawList(List<Entry> listItems) {
        Log.d(TAG, "drawList");
        final ListView list = (ListView) findViewById(R.id.list);
        final ArrayAdapter<Entry> itemsAdapter =
                new ArrayAdapter<>(this,
                        android.R.layout.simple_list_item_1,
                        listItems);
        list.setAdapter(itemsAdapter);
    }

//    List<Entry> sortList(List<Entry> list) {
//        List<Entry> sortedList = new ArrayList<>();
//        sortedList.addAll(list);
//        Collections.sort(sortedList);
//        return sortedList;
//    }
}