package com.example.mysampleapp

import android.app.AlertDialog
import android.os.Bundle
import androidx.appcompat.app.AppCompatActivity
import com.jakewharton.rxbinding2.InitialValueObservable
import com.jakewharton.rxbinding2.view.RxView
import com.jakewharton.rxbinding2.widget.RxTextView
import io.reactivex.Observable
import io.reactivex.android.schedulers.AndroidSchedulers
import kotlinx.android.synthetic.main.activity_read_two_text.*

class ReadTwoTextActivity : AppCompatActivity() {
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_read_two_text)

        val input1: InitialValueObservable<CharSequence> = RxTextView.textChanges(inputText1)
        val input2: InitialValueObservable<CharSequence> = RxTextView.textChanges(inputText2)

        val combinedString: Observable<String> = Observable.combineLatest(
            input1, input2
        ) { a, b -> a.toString() + " " + b }

        combinedString.subscribe(results::setText)

        // coffee break chapter 8
        val showAlert = RxView.clicks(btnShowAlert)

        val dialogInformationObservable: Observable<Pair<String, String>> =
            Observable.combineLatest(input1, input2) { input1, input2 ->
                Pair( input1.toString(), input2.toString()) }

        val showDialogEventObservable: Observable<Pair<String, String>> =
            showAlert.withLatestFrom(dialogInformationObservable)
            { i, dialogInformationObservable -> dialogInformationObservable }

        showDialogEventObservable
            .observeOn(AndroidSchedulers.mainThread())
            .subscribe { (first, second) ->
                AlertDialog.Builder(this)
                    .setTitle(first)
                    .setMessage(second)
                    .show()
            }
    }

}
