package com.example.mysampleapp

import android.content.Context
import android.content.Intent
import android.net.ConnectivityManager
import android.net.NetworkInfo
import android.os.Bundle
import android.util.Log
import androidx.appcompat.app.AppCompatActivity
import com.github.pwittchen.reactivenetwork.library.ReactiveNetwork
import io.reactivex.Observable
import kotlinx.android.synthetic.main.activity_main.*
import rx.android.schedulers.AndroidSchedulers
import rx.schedulers.Schedulers


class MainActivity : AppCompatActivity() {
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_main)

        Convert.setOnClickListener {
            startActivity(Intent(this, CurrencyActivity::class.java))
        }

        ConvertVM.setOnClickListener {
            startActivity(Intent(this, CurrencyConverterActivity::class.java))
        }

        ConvertLD.setOnClickListener {
            startActivity(Intent(this, CurrencyLiveDataActivity::class.java))
        }

        LiveSearch.setOnClickListener {
            startActivity(Intent(this, LiveSearchActivity::class.java))
        }

        TextSearch.setOnClickListener {
            startActivity(Intent(this, TextSearchActivity::class.java))
        }

        LibraryAdmin.setOnClickListener {
            startActivity(Intent(this, LibraryAdminActivity::class.java))
        }

        RSSFeed.setOnClickListener {
            startActivity(Intent(this, RssFeedActivity::class.java))
        }

        CreditCardValidator.setOnClickListener {
            startActivity(Intent(this, CreditCardActivity::class.java))
        }

        ReadTwoText.setOnClickListener {
            startActivity(Intent(this, ReadTwoTextActivity::class.java))
        }

        CheckInternet.setOnClickListener {
            isInternetOn(this)?.observeOn(io.reactivex.android.schedulers.AndroidSchedulers.mainThread())
                ?.subscribe { s ->
                    if (s == true) internetStatus.setText("Connected") else internetStatus.setText(
                        "Not connected"
                    )
                }
        }

        // use ReactiveNetwork to check internet connection
        ReactiveNetwork.observeNetworkConnectivity(this)
            .subscribeOn(Schedulers.io())
            .observeOn(AndroidSchedulers.mainThread())
            .subscribe { connectivity ->
                if (connectivity.state == NetworkInfo.State.DISCONNECTED) {
                    Log.d("TAG", "Connection lost")
                } else if (connectivity.state == NetworkInfo.State.CONNECTED) {
                    Log.d("TAG", "Connected")
                }
            }
    }

    private fun isInternetOn(context: Context): Observable<Boolean?>? {
        val connectivityManager =
            context.getSystemService(Context.CONNECTIVITY_SERVICE) as ConnectivityManager
        val activeNetworkInfo = connectivityManager.activeNetworkInfo
        return Observable.just(activeNetworkInfo != null && activeNetworkInfo.isConnected)
    }
}