package com.example.mysampleapp

import android.os.Bundle
import android.text.Editable
import android.text.TextWatcher
import android.widget.ArrayAdapter
import androidx.appcompat.app.AppCompatActivity
import com.jakewharton.rxbinding2.widget.RxTextView
import io.reactivex.android.schedulers.AndroidSchedulers
import kotlinx.android.synthetic.main.activity_live_search.*
import java.util.*
import java.util.concurrent.TimeUnit

class LiveSearchActivity : AppCompatActivity() {

    var arrayAdapter: ArrayAdapter<String>? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_live_search)

        arrayAdapter = ArrayAdapter<String>(this, android.R.layout.simple_list_item_1)
        search_results.setAdapter(arrayAdapter)

//        edit_text.addTextChangedListener(textWatcher)

        RxTextView.textChanges(edit_text)
            .filter { text -> text.length >= 3 }
            .debounce(150, TimeUnit.MILLISECONDS)   // need to have schedulers
            .observeOn(AndroidSchedulers.mainThread())  // make sure import the correct package
            .subscribe(::updateSearchResults)
    }

    private fun clearSearchResults() {
        arrayAdapter?.clear()
    }

    private fun updateSearchResults(text: CharSequence) {
        // Create some random results
        val list: MutableList<String> = ArrayList()
        for (i in 0..3) {
            list.add("" + text + Math.random())
        }
        arrayAdapter!!.clear()
        arrayAdapter!!.addAll(list)
    }

    private val textWatcher = object : TextWatcher {
        override fun afterTextChanged(s: Editable?) {
        }
        override fun beforeTextChanged(s: CharSequence?, start: Int, count: Int, after: Int) {
        }
        override fun onTextChanged(s: CharSequence?, start: Int, before: Int, count: Int) {
            if (s?.length!! >= 3) {
                updateSearchResults(s)
            }
        }
    }
}

