package com.test;

import java.util.ArrayList;
import java.util.List;

import com.domain.ApplicationProg;
import com.domain.Employee;
import com.domain.ImplementationProg;
import com.domain.Programmer;
import com.domain.Shape;

public class TestPoly {

	public static void main(String[] args) {
		// non-generic
		List list = new ArrayList();

		list.add("test");
		list.add(123);
		list.add(true);
		list.add(new Shape());

		// retrieve values from list, type checking
		for (Object o : list) {
			if (o instanceof String) {
				System.out.println("string: " + o);
			} else if (o instanceof Integer) {
				System.out.println("integer: " + o);
			} else if (o instanceof Boolean) {
				System.out.println("boolean: " + o);
			} else if (o instanceof Shape) {
				System.out.println("shape: " + o);
				Shape s = (Shape) o; // casting

			}
		}

		// generic - can only add string
		List<String> genlist = new ArrayList<>();

		genlist.add("test");
//		genlist.add(123);
//		genlist.add(true);
//		genlist.add(new Shape());

		for (String s : genlist) {
			System.out.println(s);
		}

		List<Programmer> plist = new ArrayList<>();
		List<ImplementationProg> ilist = new ArrayList<>();
		List<Employee> elist = new ArrayList<>();

		plist.add(new ImplementationProg(2, "sue", "project6"));
		plist.add(new ApplicationProg(9, "lily", "project8"));

		ilist.add(new ImplementationProg(6, "suzy", "project7"));

		elist.add(new Employee(19));
		elist.add(new ImplementationProg(88, "ron", "project10"));
		elist.add(new ApplicationProg(99, "jon", "project11"));
//		elist.add(plist);

		Employee[][] emps = new Employee[2][2];
		Programmer[] progs = new Programmer[2];
		ImplementationProg[] ips = new ImplementationProg[2];

		System.out.println("===================");
		
		for (int i = 0; i < 2; i++) {
			progs[i] = new ApplicationProg(i, "testap", "testprojap");
			ips[i] = new ImplementationProg(i, "testip", "testprojip");
		}

		emps[0] = progs;
		emps[1] = ips;

		for (int i = 0; i < 2; i++) {
			for (int j = 0; j < 2; j++) {
				System.out.println(emps[i][j]);
			}
		}
	}

}
