package com.test;

import com.domain.Employee;
import com.domain.ImplementationProg;
import com.domain.Printable;
import com.domain.Programmer;

public class TestEmployee {

	public static void main(String[] args) {

		Employee emp = new Employee(1, "John");
		emp.testprint();
		emp.print();
		
		Employee emp2 = new Employee(1, "John");
		
		System.out.println("Compare emp and emp2:  " + emp.equals(emp2));
		
		System.out.println();

		ImplementationProg ip = new ImplementationProg(2, "Sam", "Project1");
		ip.calculate();
		ip.display();
		ip.print();
		ip.testprint();

		System.out.println(ip);

		// polymophism
		Programmer prog = new ImplementationProg(3, "Bob", "project2");

		Printable p = new Employee(1);
		p = new ImplementationProg(5, "JJ", "project4");
		p = prog;

		testpoly(emp);
		testpoly(prog);
		testpoly(ip);
	}

	// polymorphic argument
	private static void testpoly(Employee e) {
		System.out.println("testpoly");

		// check the true type of e
		if (e instanceof ImplementationProg) {
			System.out.println("ImplementationProg object");
			// before casting - only can call methods from Employee
			e.print();
			e.testprint();
			System.out.println(e);

			System.out.println("After casting/restore type...");
			// casting (restore true type of object)
			// now can call methods from Programmer/ImplementationProg
			ImplementationProg obj = (ImplementationProg) e;
			obj.calculate();
			obj.display();
			System.out.println(obj);
			
		} else if (e instanceof Employee) {
			System.out.println("Employee object");

		}

	}

}
