package com.example.stream;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public class StreamDemo {

	public static void main(String[] args) {
		// generate a list of numbers
		List<Integer> numbers = Arrays.asList(1, 2, 3, 4, 5);

		// define a function to calculate the squares
		Function<Object, Integer> squarefun = x -> {
			int y = (Integer) x; // convert object to int
			return y * y;
		};

		// map
		// open list for stream
		// call map and apply function to calculate squares
		// print out to console
		numbers.stream().map(squarefun).forEach(x -> System.out.println(x));

		// alternatively
		for (int i : numbers) {
			System.out.println((i * i));
		}

		// assigned calculated values to a variable (collect operation)
		List<Integer> squared = numbers.stream().map(squarefun).collect(Collectors.toList());

		// then display squared
		squared.stream().forEach(x -> System.out.println(x));

		
		
		// filter
		List<String> names = Arrays.asList("John", "Bob", "David", "James");

		// filter out name that starts with J
		List<String> result = names.stream().filter(s -> s.startsWith("J")).collect(Collectors.toList());
		// display result
		result.stream().forEach(s -> System.out.println(s));

		
		// alternatively
		names.stream().filter(s -> s.startsWith("J")).forEach(s -> System.out.println(s));
		
		// rewrite map operation
		numbers.stream().map(x -> x * x).forEach(x -> System.out.println(x));
	}

}
