package com.example.stream;

import java.util.ArrayList;
import java.util.List;

/**
 * 
 * @author Iverson
 *
 *         use map() to create a new stream that contains only selected aspects
 *         of the original stream
 */

class NamePhoneEmail {
	String name;
	String phone;
	String email;

	public NamePhoneEmail(String n, String p, String e) {
		name = n;
		phone = p;
		email = e;
	}
}

class NamePhone {
	String name;
	String phone;

	public NamePhone(String n, String p) {
		name = n;
		phone = p;
	}
}

class NameEmail {
	String name;
	String email;

	public NameEmail(String n, String e) {
		name = n;
		email = e;
	}
}

public class SelectMapDemo {

	public static void main(String[] args) {

		// create a list of names, phones and emails
		List<NamePhoneEmail> list = new ArrayList<>();

		// add items to list
		list.add(new NamePhoneEmail("Larry", "555-5555", "larry@example.com"));
		list.add(new NamePhoneEmail("James", "111-1111", "james@example.com"));
		list.add(new NamePhoneEmail("Mary", "123-4567", "mary@example.com"));

		// display to console using stream
		System.out.println("== Original List ==");
		list.stream().forEach(x -> System.out.println(x.name + ", " + x.phone + ", " + x.email));

		// use map to select name and phone only, then display
		System.out.println("== Updated List ==");
		list.stream().map(x -> new NamePhone(x.name, x.phone))
				.forEach(x -> System.out.println(x.name + ", " + x.phone));
		
		
		System.out.println("== Map and Filter ==");
		// map name and email only, filter name that starts with J, then display
		list.stream()
			.map(x -> new NameEmail(x.name, x.email))
			.filter(x -> x.name.startsWith("J"))
			.forEach(x -> System.out.println(x.name + ", " + x.email));
		
		// swap map and filter
		list.stream()
			.filter(x -> x.name.startsWith("J"))
			.map(x -> new NameEmail(x.name, x.email))
			.forEach(x -> System.out.println(x.name + ", " + x.email));
	}

}
