package com.example.stream;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class ReduceDemo {

	public static void main(String[] args) {

		// create a list of numbers
		List<Integer> numbers = Arrays.asList(1, 2, 3, 4, 5, 6, 7);

		// use reduce operation to calculate result (total)
		// assign result to a variable type Optional
		Optional<Integer> result = numbers.stream().reduce((a, b) -> a + b);

		// check if there is a value in result
		if (result.isPresent()) {
			System.out.println("Result: " + result.get());
		}

		// alternatively
		// reduce(identity, accummulator);
		// a - partial total, b - next value
		int total = numbers.stream().reduce(0, (a, b) -> a + b);
		System.out.println("Total: " + total);

		// combiner operation - parallel streams
		total = numbers.stream().reduce(0, (a, b) -> a + b, (a, b) -> a * (int) Math.sqrt(b));
		System.out.println("Total2: " + total);

		total = numbers.parallelStream().reduce(0, (a, b) -> a + b, (a, b) -> a + b);
		System.out.println("Total3: " + total);

		total = numbers.stream().reduce(0, (a, b) -> a + b, (a, b) -> a + b);
		System.out.println("Total4: " + total);

		// try with another operations
		List<Double> dnumbers = Arrays.asList(1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0);

		double totalprod = dnumbers.parallelStream().reduce(1.0, (a, b) -> a * (int) Math.sqrt(b),
				(a, b) -> a * (int) Math.sqrt(b));
		System.out.println("totalprod1: " + totalprod);

		totalprod = dnumbers.stream().reduce(1.0, (a, b) -> a * (int) Math.sqrt(b), (a, b) -> a * (int) Math.sqrt(b));
		System.out.println("totalprod2: " + totalprod);
	}

}
