package com.example.lambda;

import java.util.List;
import java.util.function.Consumer;

/**
 *
 * @author MikeW
 */
public class A02Consumer {

	public static void main(String[] args) {

		// get list of transactions
		List<SalesTxn> tList = SalesTxn.createTxnList();

		// get the first transaction
		SalesTxn first = tList.get(0);

		// display formated output for first record
		first.printSummary();

		Consumer<SalesTxn> buyerConsumer = t -> System.out
				.println("Id: " + t.getTxnId() + " Buyer: " + t.getBuyerName());

		System.out.println("== Buyers - Lambda");
		tList.stream().forEach(buyerConsumer);

		// using for loop instead
		for (SalesTxn t : tList) {
			System.out.println("Id: " + t.getTxnId() + " Buyer: " + t.getBuyerName());
		}

		System.out.println("== First Buyer - Method");
		buyerConsumer.accept(first);
	}
}
