package com.example.lambda;

import java.util.List;
import java.util.function.Predicate;

/**
 *
 * @author MikeW
 */
public class A01Predicate {

	public static void main(String[] args) {

		// task: to find sales txn in MA

		// prepare data
		List<SalesTxn> list = SalesTxn.createTxnList();

		System.out.println("Without Predicate...");
		System.out.println(list.size());
		for (SalesTxn s : list) {
			if (s.getState().equals(State.MA)) {
				System.out.print(s);
			}
		}

		// alternatively, us predicate to do test
		Predicate<SalesTxn> MAsales = t -> t.getState().equals(State.MA);
		Predicate<SalesTxn> COsales = t -> t.getState().equals(State.CO);

		System.out.println("With Predicate...");
		// loop list and test each record
		for (SalesTxn s : list) {
			if (MAsales.test(s)) {
				System.out.print(s);
			}
		}

		System.out.println("With Predicate and streaming...");
		// streaming process
		System.out.println("== MA ==");
		list.stream().filter(MAsales).forEach(t -> t.printSummary());

		System.out.println("== CO ==");
		list.stream().filter(COsales).forEach(t -> t.printSummary());
	}
}