package com.example.generics;

public class TestStats {

	public static void main(String[] args) {

		Integer[] nums = { 1, 2, 3, 4, 5 };
		Double[] dnums = { 1.2, 3.4, 5.6, 7.8, 9.0 };
		Float[] fnums = { 1.2F, 3.4F, 5.6F, 7.8F, 9.0F };

		Stats<Integer> stats = new Stats<>(nums);
		System.out.println(stats.average());

		Stats<Double> dstats = new Stats<>(dnums);
		System.out.println(dstats.average());

		Stats<Number> nstats = new Stats<>(nums);
		System.out.println(nstats.average());

		Stats<Float> fstats = new Stats<>(fnums);
		System.out.println(fstats.average());

		// error
		String[] names = { "john", "luke", "bob" };
//		Stats<String> strstats = new Stats<>(names);

		// call the wildcard arg function
		System.out.println("== Integer and Double ==");
		if (stats.compareAvg(dstats)) {
			System.out.println("Same avg for Integer and Double");
		} else {
			System.out.println("Different avg for Integer and Double");
		}

		System.out.println("== Double and Integer ==");
		if (dstats.compareAvg(stats)) {
			System.out.println("Same avg for Double and Integer");
		} else {
			System.out.println("Different avg for Double and Integer");
		}

		System.out.println("== Double and Float ==");
		if (dstats.compareAvg(fstats)) {
			System.out.println("Same avg for Double and Float");
		} else {
			System.out.println("Different avg for Double and Float");
		}
	}

}
