package com.example.generics;

/**
 * 
 * Bounded Type
 * 
 * T must be a Number or any subclasses of Number
 * 
 */
public class Stats<T extends Number> {

	// define an array of numbers
	T[] numbers;

	Stats(T[] nums) {
		numbers = nums;
	}

	double average() {
		double sum = 0.0;
		for (int i = 0; i < numbers.length; i++) {
			sum += numbers[i].doubleValue();
		}
		return sum / numbers.length;
	}

	// use wildcard argument
	boolean compareAvg(Stats<?> obj) {
		if (average() == obj.average()) {
			return true;
		} else {
			return false;
		}
	}
}
