package com.example.generics;

public class GenericMethodDemo {

	/**
	 * 
	 * generic method V can be any class/type that extends T T can be any class/type
	 * that implements Comparable interface
	 */
	static <T extends Comparable<T>, V extends T> boolean isIn(T x, V[] y) {
		for (int i = 0; i < y.length; i++) {
			if (x.equals(y[i])) {
				return true;
			}
		}
		return false;
	}

	public static void main(String[] args) {

		// use isIn with integers
		Integer[] nums = { 1, 2, 3, 4, 5 };
		if (isIn(2, nums)) {
			System.out.println("2 is in nums");
		}

		// use isIn with strings
		String[] days = { "monday", "tuesday", "wednesday" };
		if (isIn("monday", days)) {
			System.out.println("monday is in days");
		}

		// if use incompatible types - error
		if (isIn("monday", nums)) {
			// not compatible (string and integer)
		}

		Double[] dnums = { 1.0, 2.0, 3.0 };
		if (isIn(1, dnums)) {
			// not compatible (int and Double)
		}
	}

}
