package com.example.generics;

// generic interface
interface MinMax<T extends Comparable<T>> {

	T min();

	T max();
}

// class that implements interface
// this class itself is generic
class MyClass<T extends Comparable<T>> implements MinMax<T> {

	T[] vals;

	MyClass(T[] o) {
		vals = o;
	}

	@Override
	public T min() {
		T v = vals[0];
		for (int i = 0; i < vals.length; i++) {
			if (vals[i].compareTo(v) < 0)
				v = vals[i];
		}
		return v;
	}

	@Override
	public T max() {
		T v = vals[0];
		for (int i = 0; i < vals.length; i++) {
			if (vals[i].compareTo(v) > 0)
				v = vals[i];
		}
		return v;
	}
}

public class GenericInterfaceDemo {

	public static void main(String[] args) {

		// let's prepare test data
		Integer[] nums = { 1, 2, 3, 4, 5 };
		Character[] chars = { 'a', 'b', 'c', 'd', 'e' };

		// create object of MyClass
		MyClass<Integer> iob = new MyClass(nums);
		MyClass<Character> cob = new MyClass(chars);

		System.out.println("Min value in nums: " + iob.min());
		System.out.println("Max value in nums: " + iob.max());

		System.out.println("Min value in chars: " + cob.min());
		System.out.println("Max value in chars: " + cob.max());
	}

}
