package com.example.generics;

class TwoD {
	int x, y;

	public TwoD(int x, int y) {
		this.x = x;
		this.y = y;
	}
}

class ThreeD extends TwoD {
	int z;

	public ThreeD(int x, int y, int z) {
		super(x, y);
		this.z = z;
	}
}

class FourD extends ThreeD {
	int t;

	public FourD(int x, int y, int z, int t) {
		super(x, y, z);
		this.t = t;
	}
}

// bounded type
class Coords<T extends TwoD> {
	T[] coords;

	public Coords(T[] o) {
		coords = o;
	}
}

public class BoundedWildcardDemo {

	// define a static method to display coordinates

	// wildcard
	static void showXY(Coords<?> c) {
		System.out.println("X Y Coordinates");
		for (int i = 0; i < c.coords.length; i++) {
			System.out.println(c.coords[i].x + ", " + c.coords[i].y);
		}
		System.out.println();
	}

	// bounded wildcard
	static void showXYZ(Coords<? extends ThreeD> c) {
		System.out.println("X Y Z Coordinates");
		for (int i = 0; i < c.coords.length; i++) {
			System.out.println(c.coords[i].x + ", " + c.coords[i].y + ", " + c.coords[i].z);
		}
		System.out.println();
	}

	public static void main(String[] args) {

		// let's prepare test data
		TwoD[] list1 = { new TwoD(1, 2), new TwoD(3, 4) };
		ThreeD[] list2 = { new ThreeD(1, 2, 3), new ThreeD(4, 5, 6) };
		FourD[] list3 = { new FourD(1, 2, 3, 4), new FourD(5, 6, 7, 8) };

		// use the bounded type
		Coords<TwoD> coords1 = new Coords(list1);
		Coords<ThreeD> coords2 = new Coords(list2);
		Coords<FourD> coords3 = new Coords(list3);

		// display coordinates
		showXY(coords1);
		showXY(coords2);
		showXY(coords3);

//		showXYZ(coords1);	// error
		showXYZ(coords2);
		showXYZ(coords3);
	}

}
