package com.domain;

import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;

class MyCallable implements Callable<Object> {

	@Override
	public Object call() throws Exception {
		// create a random number generator
		Random generator = new Random();
		Integer randomNumber = generator.nextInt();

		// to simulate heavy computation
		// we delay the thread for some random time
		// i.e. put thread to sleep
		Thread.sleep(3000);
		return randomNumber;
	}

}

public class TestCallable {

	public static void main(String[] args) throws InterruptedException, ExecutionException {
		// FutureTask is a concrete class that
		// implements both Runnable and Callable
		FutureTask[] randomNumberTasks = new FutureTask[5];

		// prepare the task for execution
		for (int i = 0; i < randomNumberTasks.length; i++) {
			Callable callable = new MyCallable();

			// create FutureTask with Callable
			randomNumberTasks[i] = new FutureTask(callable);

			// create thread to start running
			Thread t = new Thread(randomNumberTasks[i]);
			t.start();
		}

		// start reading the return value when it's ready
		for (int i = 0; i < randomNumberTasks.length; i++) {
			System.out.println(randomNumberTasks[i].get());
			
			// this method blocks until the result is obtained from the executed tasks
		}
	}

}
