package com.domain;

public class Shape {
	protected int width;
	protected int height;
	protected static int count;

	static {
		count = 0;
		System.out.println("initializer");
	}

	protected final int MAX_NUM;

	public Shape() {
		this.MAX_NUM = 100; // delayed initialization of constant
		System.out.println("constructor");
	}

	// no constructor defined

	public static void main(String[] args) {
		Rectangle2 rect = new Rectangle2(2, 4);
		Rectangle2.count++;
		System.out.println(Rectangle2.count);

		Rectangle2 rect2 = new Rectangle2(2, 4);
		Rectangle2.count++;
		System.out.println(Rectangle2.count);
	}

	public final int area() {
		return width * height;
	}
}

class Circle extends Shape {
	private int radius;

	public int circlearea() {
		return (int) Math.PI * radius * radius;
	}
}

final class Rectangle2 extends Shape {

	public Rectangle2(int w, int h) {
		super(); // implicit call to superclass's constructor
		width = w;
		height = h;
		System.out.println("Rectangle2 construcor");
	}

}

//class Square extends Rectangle2 {
//
//}