package com.domain;

public abstract class Programmer extends Employee {
	
	protected String project;
	
	protected Programmer(int id, String name, String project) {
		super(id, name);	// call superclass's constructor
		this.project = project;
		System.out.println("Programmer constructor");
	}
	
	protected Programmer(String project) {
		this(0, "", project);	// call another constructor in the same class
		this.project = project;
		System.out.println("Programmer constructor");
	}
	
	// method with body/implementation
	// non-abstract method (concrete method)
	public void display() {
		System.out.println(id + name + project);
	}
	
	// non-concrete method
	public abstract void calculate();
}
