package com.domain;

interface StringFun {
	String fun(String s);
}

// class defines static method
class MyStringOps {
	static String strReverse(String str) {
		String result = "";
		for (int i = str.length() - 1; i >= 0; i--) {
			result += str.charAt(i);
		}
		return result;
	}
}

// class defines non-static (instance) method
class MyStringOps2 {
	String greeting(String name) {
		return "Hello " + name;
	}
}

public class MethodRefDemo {

	// defines a static method that will accept a function as parameter
	// use method reference when passing function as parameter
	static String stringOp(StringFun sf, String s) {
		return sf.fun(s);
	}

	public static void main(String[] args) {

		String input = "Lambdas add power to Java";
		String output;

		// use method reference here
		output = stringOp(MyStringOps::strReverse, input);

		System.out.println("Input: " + input);
		System.out.println("Output: " + output);

		// create object of MyStringOps2
		MyStringOps2 sop = new MyStringOps2();

		// use instance reference instead to call method
		output = stringOp(sop::greeting, "Bob");

		System.out.println(output);
		System.out.println(stringOp(sop::greeting, "Bob"));
	}

}
