package com.domain;

// functional interface
interface Greeting {
	public void greet();
}

interface MyNumber {
	public double getValue();
}

// concrete class implements functional interface
class EnglishGreeting implements Greeting {
	public void greet() {
		System.out.println("Good morning! Hello!");
	}
}

class MalayGreeting implements Greeting {
	public void greet() {
		System.out.println("Selamat pagi!");
	}
}

public class HelloLambda {

	public static void main(String[] args) {
		// create object greeting
		EnglishGreeting eg = new EnglishGreeting();
		eg.greet();

		MalayGreeting mg = new MalayGreeting();
		mg.greet();

		// polymorphism
		Greeting g = new EnglishGreeting();
		g.greet();

		g = new MalayGreeting();
		g.greet();

		// anonymous class
		g = new Greeting() {

			@Override
			public void greet() {
				System.out.println("Hola");
			}
		};
		g.greet();

		// lambda expression
		g = () -> System.out.println("Zaoshang Hao!");
		g.greet();

		MyNumber number = () -> 123.45;
		System.out.println("Value: " + number.getValue());

		number = () -> Math.random() * 100;
		System.out.println("Value: " + number.getValue());

		number = () -> 123;
		System.out.println("Value: " + number.getValue());
	}

}
