package com.domain;

// generic functional interface
// T - can be any type
interface SomeFun<T> {
	T fun(T t);
}

public class GenericLambdaDemo {

	static String msg = "Hello";
	
	public static void main(String[] args) {

		int num = 9;
//		num = 11;
		
		// lambda expression that reverse the characters in a string
		SomeFun<String> reverse = (str) -> {

			System.out.println(msg);
			System.out.println(num);
			
//			num = 10;

			String result = "";

			for (int i = str.length() - 1; i >= 0; i--) {
				result += str.charAt(i);
			}
			return result;
		};
		System.out.println("Lambda reversed is " + reverse.fun("Lambda"));
		System.out.println("Expression reversed is " + reverse.fun("Expression"));

		// lambda expression that computes factorial of an int value
		SomeFun<Integer> factorial = (n) -> {
			int result = 1;

			for (int i = 1; i <= n; i++) {
				result = i * result;
			}
			return result;
		};

		System.out.println("The factorial of 3 is " + factorial.fun(3));
		System.out.println("The factorial of 5 is " + factorial.fun(5));

		// lambda expression to process employee object
		SomeFun<Employee> display = (e) -> e;
		System.out.println(display.fun(new Employee(1, "John Smith")));
	}

}
