package com.domain;

interface MyFun<T> {
	int fun(T[] vals, T v);
}

class MyArrayOps {
	static <T> int countMatching(T[] vals, T v) {
		int count = 0;
		for (int i = 0; i < vals.length; i++) {
			if (vals[i] == v)
				count++;
		}
		return count;
	}
}

public class GenericFunctionDemo {

	static <T> int myOp(MyFun<T> f, T[] vals, T v) {
		return f.fun(vals, v);
	}

	public static void main(String[] args) {
		// prepare 2 arrays of integers and strings
		Integer[] nums = { 1, 2, 3, 4, 2, 1, 3, 5, 6 };
		String[] names = { "john", "john", "bob", "sarah", "john" };

		int count = 0;

		// process array of numbers
		count = myOp(MyArrayOps::<Integer>countMatching, nums, 2);
		System.out.println("nums contains " + count + " 2s");

		count = myOp(MyArrayOps::<String>countMatching, names, "john");
		System.out.println("names contains " + count + " johns");
	}
}
