package com.domain;

public interface Fly {

	// abstract method
	public void takeoff();

	// default interface method
	public default void flying() {
		System.out.println("flying...");

		// call private interface method
		landing();
	}

	// private interface method
	private static void landing() {
		System.out.println("landing...");
//		parking();	// private static calling non-static - compile error
	}

	private void parking() {
		landing(); // private non-static calling static - ok
		System.out.println("parking...");
	}
}

class Airplane implements Fly {

	@Override
	public void takeoff() {
		System.out.println("Airplane is taking off...");
	}

}