package com.domain;

public class Employee implements Printable {

	protected int id;
	protected String name;

	public Employee(int id, String name) {
		System.out.println("Employee constructor");
		this.id = id;
		this.name = name;
	}

	public Employee(int id) {
		this.id = id;
		this.name = "";
	}

	@Override
	public void print() {
		System.out.println(id + " " + name);
	}

	@Override
	public void print2() {
		System.out.println("Employee:print2");
	}

	@Override
	public String toString() {
		return "== Employee Details ==\nId: " + id + "\nName: " + name + "\n";
	}

	@Override
	public boolean equals(Object obj) {
		// define the equality function
		// 2 object employees are equal if they have the same id and name
		if (((Employee) obj).id == id && ((Employee) obj).name.equals(name)) {
			return true;
		} else {
			return false;
		}
	}
}
