package com.mybank.domain;

public class CheckingAccount extends Account {

	private double overdraftAmount;

	public CheckingAccount(double initBalance, double overdraft) {
		super(initBalance);
		this.overdraftAmount = overdraft;
	}

	public CheckingAccount(double initBalance) {
		this(initBalance, 0);
	}

	public void withdraw(double amt) throws OverdraftException {
		if (amt < balance) {
			balance -= amt;
		} else {
			// calculate overdraft needed
			double overdraftNeeded = amt - balance;

			// check if overdraftAmount is sufficient
			if (overdraftNeeded < overdraftAmount) {
				balance = 0;
				overdraftAmount -= overdraftNeeded;
			} else {
				throw new OverdraftException("Insufficient funds for overdraft protection", overdraftNeeded);
			}
		}
	}
}
