package com.mybank.data;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Scanner;

import com.mybank.domain.Bank;
import com.mybank.domain.CheckingAccount;
import com.mybank.domain.Customer;
import com.mybank.domain.SavingsAccount;

public class DataSource {

	private File dataFile;

	public DataSource(String dataFilePath) {
		dataFile = new File(dataFilePath);
	}

	public void loadData() throws FileNotFoundException {
		// use scanner class to read file
		Scanner input = new Scanner(dataFile);

		Customer customer;

		// start reading the datafile
		// first line - no of customer
		int numOfCustomers = input.nextInt();

		// start reading customer details
		for (int index = 0; index < 4; index++) {
			// start reading first and last name
			String first = input.next();
			String last = input.next();
			int numOfAccounts = input.nextInt();

			// add customer to bank
			Bank.addCustomer(first, last);

			// get the customer from bank
			customer = Bank.getCustomer(index);

			// creating customer accounts
			while (numOfAccounts-- > 0) {
				// get the account type
				char accountType = input.next().charAt(0);

				switch (accountType) {
				case 'S': {
					double initBalance = input.nextDouble();
					double interestRate = input.nextDouble();
					customer.addAccount(new SavingsAccount(initBalance, interestRate));
					break;
				}
				case 'C': {
					double initBalance = input.nextDouble();
					double overdraft = input.nextDouble();
					customer.addAccount(new CheckingAccount(initBalance, overdraft));
					break;
				}
				}
			}
		}
	}
}
