package com.example.tread;
import java.util.ArrayList;
import java.util.List;

public class SyncStack {

	private List<Character> buffer = new ArrayList<>();

	// define method to retrieve character from the s
	public synchronized char pop() {
		char c;
		while (buffer.size() == 0) {
			try {
				// wait if stack is empty
				this.wait();
			} catch (InterruptedException e) {
				// ignore it...
			}
		}
		// if stack is not empty, then pop the character
		c = buffer.remove(buffer.size() - 1);
		return c;
	}

	// define method to put/add character to stack
	public synchronized void push(char c) {
		this.notify();
		buffer.add(c);
	}
}
