package com.example.interfaces;

interface FirstInterface {
	public void first();

	// a default method
	default String getMessage() {
		displayString();
		return "Hello World!";
	}

	static void displayNumber() {
		System.out.println("Number is 9");
	}

	// private method in interface
	private void displayString() {
		System.out.println("This is just a test");
	}
}

interface SecondInterface {
	public void second();

	// another default method
	default void getGreeting() {
		System.out.println("Good afternoon everyone.");
	}

}

public class MyClass implements FirstInterface, SecondInterface {

	@Override
	public void second() {
		System.out.println("This is the second method from SecondInterface");
	}

	@Override
	public void first() {
		System.out.println("This is the first method from FirstInterface");
	}

	// override default method's implementation
	@Override
	public void getGreeting() {
		System.out.println("Good morning everyone.");
	}

	public static void main(String[] args) {
		MyClass mc = new MyClass();
		mc.first();
		mc.second();
		System.out.println(mc.getMessage());
		mc.getGreeting();

		// use interface name to call static method
		FirstInterface.displayNumber();
	}

}
