package com.example.generic;

/*
 * Bounded Type
 * T must be a Number or any classes that extends Number (subclass)
 * 
 */
public class Stats<T extends Number> {

	// array of numbers
	T[] numbers;

	Stats(T[] nums) {
		numbers = nums;
	}

	double average() {
		double sum = 0.0;

		for (int i = 0; i < numbers.length; i++) {
			sum += numbers[i].doubleValue();
		}
		return sum / numbers.length;
	}

	// use wildcard
	boolean compareAvg(Stats<?> obj) {
		if (average() == obj.average()) {
			return true;
		}
		return false;
	}
}
