package com.example.domain;

public class Box {

	// instance variables
	// default access modifier - accessible within the package only
	private double width;
	private double height;
	private double depth;
	private String name;

	// static variable
	// static variable is basically a class variable
	public static int counter;

	// define a method to update counter
	public void updateCounter() {
		counter++;
	}

	public Box() {
		System.out.println("Box constructor executed...");
		width = 10;
		height = 10;
		depth = 10;
		name = "box";
		updateCounter();
	}

	// parameterized constructor
	public Box(double width, double height, double depth, String name) {
		System.out.println("Box parameterized constructor executed...");
		this.width = width;
		this.height = height;
		this.depth = depth;
		this.name = name;
		updateCounter();
	}

	// overloaded constructor
	public Box(String name, double width, double height, double depth) {
		System.out.println("Overloaded constructor executed...");
		this.width = width;
		this.height = height;
		this.depth = depth;
		this.name = name;
		updateCounter();
	}

	public double calculateVolume() {
		// calculate volume for box
		return width * height * depth;
	}

	public void display() {
		System.out.println("Width = " + width);
		System.out.println("Height = " + height);
		System.out.println("Depth = " + depth);
		System.out.println("Name = " + name);
		System.out.println();
	}

	// method that takes parameters
	public void setDimension(double width, double height, double depth, String name) {
		this.width = width;
		this.height = height;
		this.depth = depth;
		this.name = name;
	}

	@Override
	public String toString() {
		return "== Box Details ==\n" + "Name = " + name + "\n" + "Width = " + width + "\n" + "Height = " + height + "\n"
				+ "Depth = " + depth + "\n" + "Volume = " + calculateVolume() + "\n";
	}

	public double getWidth() {
		return width;
	}

	public void setWidth(double width) {
		this.width = width;
	}

	public double getHeight() {
		return height;
	}

	public void setHeight(double height) {
		this.height = height;
	}

	public double getDepth() {
		return depth;
	}

	public void setDepth(double depth) {
		this.depth = depth;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	// define a method that takes an object as parameter
	// java is strictly pass-by-value
	public void updateBox(Box box) {
		box.name = "Updated-" + box.name;
		box.width = box.width * 2;
		box.height = box.height * 2;
		box.depth = box.depth * 2;
	}

	// define a method that will return an object
	public Box getBox(double width, double height, double depth, String name) {
//		Box newbox = new Box(width, height, depth, name);
//		return newbox;

		return new Box(width, height, depth, name);
	}

//	public Box getBox(String name, double width, double height, double depth) {
////		Box newbox = new Box(width, height, depth, name);
////		return newbox;
//
//		return new Box(name, width, height, depth);
//	}
//	
//	public Box getBox(String name, double width, double height) {
////		Box newbox = new Box(width, height, depth, name);
////		return newbox;
//
//		return new Box(name, width, height, depth);
//	}
//	
//	public Box getBox(String name, double width) {
////		Box newbox = new Box(width, height, depth, name);
////		return newbox;
//
//		return new Box(name, width, height, depth);
//	}

	// use varargs instead
	public Box getBox(String name, double... values) {
		// values is actually an array
		double w = 10.0;
		double h = 10.0;
		double d = 10.0;

		if (values.length == 2) {
			w = values[0];
			h = values[1];
		} else if (values.length == 1) {
			w = values[0];
		} else {
			w = values[0];
			h = values[1];
			d = values[2];
		}
		return new Box(name, w, h, d);
	}
}
