
// define a class that extends Thread class
class MyThread extends Thread {

	String threadName;

	public MyThread(String name) {
		threadName = name;
	}

	@Override
	public void run() {
		// define the job/process to be executed
		System.out.println(threadName + " is starting...");
		try {
			for (int count = 0; count < 10; count++) {
				// put the thread to sleep
				Thread.sleep(1000);
				// once timed up, thread will wakes up and throw InterruptException
				// then continue from here
				System.out.println("In " + threadName + ", count is " + count);
				System.out.println(threadName + " is still alive? " + Thread.currentThread().isAlive());
			}
		} catch (InterruptedException e) {
			System.out.println(threadName + " interrupted.");
		}
		System.out.println(threadName + " is terminating...");
	}
}

public class TestThread {

	public static void main(String[] args) {
		System.out.println("Main thread starting...");

		// create thread object MyThread
		MyThread t1 = new MyThread("T1");
		MyThread t2 = new MyThread("T2");

		// start the threads
		t1.start();
		t2.start();

		System.out.println("Main thread ending...");
	}

}
