
public class LoopExample {

	public static void main(String[] args) {
		// define an array/sequence of numbers
		int[] numbers = { 10, 20, 30, 40, 50 };

		System.out.println("Size of array: " + numbers.length);

		System.out.println("Use while loop to display numbers...");

		int index = 0; // initialization
		while (index < numbers.length) { // condition/expression
			System.out.println(index + "-" + numbers[index]);
			index++; // update
		}
		System.out.println("End of while loop... index = " + index);

		System.out.println("Use do-while loop to display numbers...");
		// reset index
		index = 0;
		do {
			System.out.println(index + "-" + numbers[index]);
			index++; // update
		} while (index < numbers.length); // condition/expression
		System.out.println("End of do-while loop... index = " + index);

		System.out.println("Use for loop to display numbers...");
		for (index = 0; index < numbers.length; index++) {
			System.out.println(index + "-" + numbers[index]);
		}
		System.out.println("End of for loop... index = " + index);

		System.out.println("Use enhanced for loop to display numbers...");
		for (int n : numbers) {
			System.out.println(n);
		}
		System.out.println("End of enhanced for loop... index = " + index);

		System.out.println("Display the first 3 numbers...");
		for (index = 0; index < 3; index++) {
			System.out.println(index + "-" + numbers[index]);
		}

		System.out.println("Use break to exit loop...");
		for (int i = 0; i < 100; i++) {
			// check if i is 10, if true then break (exit loop)
			if (i == 10)
				break;
			System.out.println("i: " + i);
		}
		System.out.println("Loop completed");

		System.out.println("Use break as a form of goto...");
		boolean t = true;
		first: {
			second: {
				third: {
					System.out.println("Before the break.");
					if (t)
						break first;
					System.out.println("This won't execute (third).");
				}
				System.out.println("This is after third block.");
			}
			System.out.println("This is after second block.");
		}
		System.out.println("This is after first block.");

		System.out.println("Use continue with for loop...");
		for (int i = 0; i < 10; i++) {
			// skip even numbers
			if (i % 2 == 0)
				continue;
			System.out.println(i + " "); // skip when continue
		}

		int[] nums = new int[5];
		int age = 8;

		// new keyword used to create new object
		// object is a reference type variable
		// reference => memory address
		String clothing1;
		String clothing2;
		clothing1 = "socks";
		clothing2 = new String("socks");
		if (clothing1 == clothing2) {
			// == will check for value ie. reference (memory address)
			System.out.println("same");
		} else {
			System.out.println("different");
		}
		// literals -> "socks" and "pants"

		// check the literals/contents
		if (clothing1.equals(clothing2)) {
			System.out.println("same");
		} else {
			System.out.println("different");
		}

	}

}
