
// lambda expression: () -> {}

// functional interface: interface that contains only 1 abstract method
interface IGreeting {
	public String greet();
}

// define a class that implement interface
// this class is sometimes called concrete class
class MyGreeting implements IGreeting {
	@Override
	public String greet() {
		return "Selamat Pagi";
	}
}

class SpanishGreeting implements IGreeting {
	@Override
	public String greet() {
		return "Hola";
	}
}

public class LambdaExample {
	public static void main(String[] args) {
		MyGreeting mg = new MyGreeting();
		System.out.println(mg.greet());
		
		SpanishGreeting sg = new SpanishGreeting();
		System.out.println(sg.greet());
		
		// polymorphism
		IGreeting g = new MyGreeting();
		System.out.println(g.greet());
		
		g = new SpanishGreeting();
		System.out.println(g.greet());
		
		// anonymous class - inline implementation
		g = new IGreeting() {
			@Override
			public String greet() {
				return "Good Morning";
			}
		};
		System.out.println(g.greet());
		
		// lambda expression - simplify this syntax
		// anonymous method
		
		String name = "John";
		
		g = () -> {
			return "Good Afternoon " + name;
		};
		System.out.println(g.greet());
	}
}
