
public class ClassMap {

	int roomNo;
	String[][] deskArray;

	public ClassMap(int id) {
		roomNo = id;
		deskArray = new String[3][4];
	}

	public void setDesk(String name) {
		outer: for (int row = 0; row < 3; row++) {
			for (int col = 0; col < 4; col++) {
				if (deskArray[row][col] == null) {
					// assign student to desk
					deskArray[row][col] = name;
					System.out.println(String.format("%s was assigned a seat at desk [%d, %d] in Room %d", name, row,
							col, roomNo));
					break outer;
				}
			}
		}
	}

	public void displayDeskMap() {
		for (int row = 0; row < 3; row++) {
			for (int col = 0; col < 4; col++) {
				if (deskArray[row][col] == null) {
					System.out.print(String.format("[%d, %d]\t", row, col));
				} else {
					System.out.print(String.format("[%s]\t", deskArray[row][col]));
				}
			}
			System.out.println();
		}
	}

	public void searchDesk(String name) {
		boolean found = false;
		outer: for (int row = 0; row < 3; row++) {
			for (int col = 0; col < 4; col++) {
				if (deskArray[row][col] != null && deskArray[row][col].equals(name) == true) {
					found = true;
					System.out.println(
							String.format("%s is sitting at desk [%d, %d] in Room %d", name, row, col, roomNo));
					break outer;
				}
			}
		}
		// if student not found
		if (!found) {
			System.out.println(name + " is not found in Room " + roomNo);
		}
	}
}
