
public class Employee {

	private String name;
	private int employeeId; // (1-10000)
	private String jobTitle;
	private int level; // (1, 2, 3)

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public int getEmployeeId() {
		return employeeId;
	}

	public void setEmployeeId(int employeeId) {
		// check valid employee id
		if (employeeId > 0 && employeeId <= 10000) {
			this.employeeId = employeeId;
		} else {
			System.out.println("Invalid employee id, range 1-10000");
		}
	}

	public void calculateEmployeeID() {
		// generate random number for employee id
		int id = (int) (Math.random() * 10000) + 1;
		setEmployeeId(id);
	}

	public String getJobTitle() {
		return jobTitle;
	}

	public void setJobTitle(String jobTitle) {
		this.jobTitle = jobTitle;
	}

	public int getLevel() {
		return level;
	}

	public void setLevel(int level) {
		// check valid level
		switch (level) {
		case 1:
		case 2:
		case 3:
			this.level = level;
			break;
		default:
			System.out.println("Invalid employee level. Level must in range 1-3 only.");
		}
		this.level = level;
	}
}
