package com.mybank.domain;

public class CheckingAccount extends Account {

	private double overdraftAmount;

	public CheckingAccount(double initBalance, double overdraft) {
		super(initBalance);
		overdraftAmount = overdraft;
	}

	public CheckingAccount(double initBalance) {
		this(initBalance, 0);
	}

	@Override
	public void withdraw(double amt) throws OverdraftException {
		// check if sufficient balance for withdrawal
		if (amt < balance) {
			balance -= amt;
		} else {
			if (overdraftAmount > 0) {
				double overdraftNeeded = amt - balance;

				// check if sufficient overdraft for withdrawal
				if (overdraftNeeded < overdraftAmount) {
					balance = 0;
					overdraftAmount -= overdraftNeeded;
				} else {
//					System.out.println("Insufficient overdraft amount for withdrawal");
					throw new OverdraftException("Insufficient funds for overdraft protection", overdraftNeeded);
				}
			} else {
//				System.out.println("Insufficient overdraft amount for withdrawal");
				throw new OverdraftException("Insufficient funds for overdraft protection", overdraftAmount);
			}
		}
	}
}
