package com.mybank.domain;

public class Account {

	protected double balance;

	protected Account(double initBalance) {
		balance = initBalance;
	}

	public double getBalance() {
		return balance;
	}

	public void withdraw(double amt) throws OverdraftException {
		if (amt < balance) {
			balance -= amt;
		} else {
//			System.out.println("Insufficient balance for withdrawal");
			throw new OverdraftException("Insufficient funds", (amt - balance));
		}
	}

	public void deposit(double amt) {
		balance += amt;
	}
}
