package com.mybank.data;

import java.io.File;
import java.io.IOException;
import java.util.Scanner;

import com.mybank.domain.Bank;
import com.mybank.domain.CheckingAccount;
import com.mybank.domain.Customer;
import com.mybank.domain.SavingsAccount;

public class DataSource {

	private File dataFile;

	public DataSource(String dataFilePath) {
		dataFile = new File(dataFilePath);
	}

	public void loadData() throws IOException {
		// prepare to read data file
		Scanner input = new Scanner(dataFile);

		Customer customer;

		// start reading data
		// get number of customers
		int numOfCustomers = input.nextInt();

		// loop each customer
		for (int index = 0; index < numOfCustomers; index++) {
			// read customer first and last name
			String firstName = input.next();
			String lastName = input.next();

			// get number of accounts for each customer
			int numOfAccounts = input.nextInt();

			// add customer to bank
			Bank.addCustomer(firstName, lastName);

			// get customer from back
			customer = Bank.getCustomer(index);

			// create customer accounts
			while (numOfAccounts-- > 0) {
				// get account type
				char accountType = input.next().charAt(0);

				switch (accountType) {
				case 'S': {
					double initBalance = input.nextDouble();
					double interestRate = input.nextDouble();
					customer.addAccount(new SavingsAccount(initBalance, interestRate));
					break;
				}
				case 'C':
					double initBalance = input.nextDouble();
					double overdraft = input.nextDouble();
					customer.addAccount(new CheckingAccount(initBalance, overdraft));
					break;
				}
			}
		}
	}
}
